foreach year in 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 {
	
	global year `year'


	use comr nbheur siren catjur catjur_1 s_brut s_brut_1 pcs pcs_1 ident_s comt apet using  "${tmp}/dads${year}", clear
		destring catjur catjur_1, replace force
	// drop Particuliers employeurs
	drop if inlist(substr(string(catjur),1,1),"1","2","3","5","6")  == 1 & substr(siren,1,1)=="P"
	drop if inlist(substr(string(catjur_1),1,1),"1","2","3","5","6")  == 1 & substr(siren,1,1)=="P"

	//allocate ZE
	gen depcom = comr
	replace depcom = comt if real(substr(comr,1,2)) >= 98 | comr == "69999" | regexm(comr,"ZZZ")
	
	replace depcom = "75056" if substr(depcom,1,2) == "75"
	replace depcom = "13055" if inrange(real(depcom),13201,13216)
	replace depcom = "69123" if inrange(real(depcom),69381,69389)
	replace depcom = "59183" if depcom == "59540" | depcom == "59248"
	destring depcom, replace force
	drop if mi(depcom)
	merge m:1 depcom using "${data}/Utils/depcom_ZE_mapping", nogen keep(1 3)
		
	replace s_brut = 0 if mi(s_brut)
	replace s_brut_1 = 0 if mi(s_brut_1)

	** -- positions
	gen researcher_1 =  inlist(pcs_1,"342B","342C","342F")
	gen engineer_1 = (substr(pcs_1,1,2) == "38" | pcs_1 == "342G")
	gen public_1			= inlist(substr(string(catjur_1),1,1),"4","7")
	gen phd_student_1  = pcs_1 == "342H"
	gen ater_1		 = pcs_1 == "342D"
	
	** -- we keep workers making more than 2000 euros per year as a public researcher at t-1
	bys ident_s: gegen s_brut_pubres_1 = sum(s_brut_1*(researcher_1+ater_1+phd_student_1+engineer_1>0)*public_1)
	keep if s_brut_pubres_1>2000 & !mi(s_brut_pubres_1)

	drop s_brut_pubres_1

	** -- 
	gen researcher 		= inlist(pcs,"342B","342C","342F")
	gen public			= inlist(substr(string(catjur),1,1),"4","7") 
	gen private			= inlist(substr(string(catjur),1,1),"1","2","3","5","6") 
	 
	gen private_1		= inlist(substr(string(catjur_1),1,1),"1","2","3","5","6") 

	gen engineer 		= (substr(pcs,1,2) == "38" | pcs == "342G")
	gen phd_student  	= pcs == "342H"
	gen ater		 	= pcs == "342D"

	/* _____________________________________________________________________________ 
		-- 	Researchers in the public sector defined based 
			on occupation x catégorie juridique 
	   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ */
	bys ident_s : gegen researcher_max = max(researcher)
	bys ident_s : gegen public_research_max = max(researcher == 1 & public == 1 )

	bys ident_s : gegen researcher_max_1 = max(researcher_1)
	bys ident_s : gegen public_research_max_1 = max(researcher_1 == 1 & public_1 == 1 )

	** -------------------------------------------------------------------------------

	gen siren_pub = siren if public_1==1
	gen s = s_brut_1*public_1

	bys ident_s (s): gen siren_pub1 = siren_pub[_N]
	bys ident_s (s): gen siren_pub2 = siren_pub[_N-1]
	bys ident_s (s): gen siren_pub3 = siren_pub[_N-3]

	drop siren_pub
	
	gen siren_priv = siren if private==1
	gen apet_priv = apet if private == 1
	destring ZE2010, replace
	gen ZE_priv = ZE2010 if private == 1
	
	
	foreach var in researcher engineer ater phd_student {
		bys ident_s: egen max_`var'_1 = max(`var'_1*public_1)
	}

	** -- researcher public at t-1
	cap drop researcher_1
	
	gen researcher_1 		= 1 if max_researcher_1 == 1
	replace researcher_1 	= 2 if max_engineer_1 == 1
	replace researcher_1 	= 3 if max_ater_1 == 1
	replace researcher_1 	= 4 if max_phd_student_1 == 1

	drop max* 
	
	bys ident_s : egen position = min(researcher_1) if researcher_1>0
		
	drop if mi(position)
	keep if private==1
	tab position
	
	gen njobs = 1 
		
	collapse (sum) nbheur s_brut njobs (first) apet_priv ZE_priv, by(siren_priv siren_pub* position)  fast

	gen research_position = "Researcher" if position==1
	replace research_position = "Pub. Engineer" if position==2
	replace research_position = "Ater" if position==3
	replace research_position = "Phd" if position==4

	drop position
	
	compress
	
	save "${tmp}/siren_priv_hire_resarch_from_siren_pub_${year}", replace
	
	
}



clear
foreach year in 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 {
	append using "${tmp}/siren_priv_hire_resarch_from_siren_pub_`year'"
	cap gen year = `year'
	replace year = `year' if mi(year)
	}
keep if !mi(siren_priv)

gcollapse (sum) nbheur s_brut njobs, by(apet_priv ZE_priv year research_position) fast

ren ZE ZE2010
ren apet* ape
keep if !mi(research_position)
preserve
gcollapse (sum) nbheur s_brut njobs, by(ape ZE2010 year) fast
ren nbheur nbheur_respubtopri
ren s_brut sal_respubtopri
ren njobs njobs_respubtopri

tempfile all
save `all'
restore
keep if research_position == "Researcher"
gcollapse (sum) nbheur s_brut njobs, by(ape ZE2010 year) fast
ren nbheur nbheur_seniorrespubtopri
ren s_brut sal_seniorrespubtopri
ren njobs njobs_seniorrespubtopri
merge 1:1 ape ZE2010 year using `all', nogen
recode *respubtopri (. = 0)
tostring ZE2010, replace format(%04.0f)
compress
save "${tmp}\siren_priv_hire_researchers_from_siren_pub.dta", replace
